/*********************************************************************************************************//**
 * @file    USART/HyperTerminal_TxRx_Interrupt/usart_int.h
 * @version $Rev:: 914          $
 * @date    $Date:: 2016-07-21 #$
 * @brief   The header file of the USART interrupt functions.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __UART_H
#define __UART_H

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"

//-----UART


#define COM1_CLK(CK)                (CK.Bit.UART0)
#define COM1_PORT                   (HT_UART0)
#define COM1_IRQn                   (UART0_IRQn)
#define COM1_IRQHandler             (UART0_IRQHandler)

#define COM1_TX_GPIO_ID             (GPIO_PB)
#define COM1_TX_AFIO_PIN            (AFIO_PIN_6)
#define COM1_TX_AFIO_MODE           (AFIO_FUN_USART_UART)

#define COM1_RX_GPIO_ID             (GPIO_PB)
#define COM1_RX_AFIO_PIN            (AFIO_PIN_8)
#define COM1_RX_AFIO_MODE           (AFIO_FUN_USART_UART)


//***********************************************************************************
/* Exported types ------------------------------------------------------------------------------------------*/
typedef enum
{
  USART_TX_INT = 1,
  USART_RX_INT = 2,
  USART_ALL_INT = 3
}USART_INT_Mode;

/* Exported constants --------------------------------------------------------------------------------------*/
#define USART_BUFSIZE   128

extern u8 URTxBuf[USART_BUFSIZE];
extern u8 URRxBuf[USART_BUFSIZE];
extern vu32 URTxReadIndex;
extern vu32 URTxWriteIndex;
extern vu32 URRxWriteIndex;


/* Exported functions --------------------------------------------------------------------------------------*/

void URAT_TimerCounter(void);
void UART_SendNEWLine(void);
void UART_SendTab(void);
void UART_SendComma(void);
void UART_SendData(char *array, u8 length);

void Analysis_Command(void);
bool DataCompare(u8 DataLen,u8 * ptrChar ,u8 * ptrChar2);


#endif /* __UART_H ------------------------------------------------------------------------------------*/
